program CURVEFIT;
{--------------------------------------------------------------------}
{  Alg5'3.pas   Pascal program for implementing Algorithm 5.3        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 5.3 (Non-linear Curve Fitting).                         }
{  Section   5.2, Curve Fitting, Page 280                            }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    GNmax = 230;
    MaxN = 100;

  type
    VECTOR = array[1..MaxN] of real;
    RVECTOR = array[0..GNmax] of real;
    LETTER = string[1];
    Status = (Computing, Done, More, Working);
    DATYPE = (DatPoints, FunPoints);
    ABTYPE = (Given, Equal, Interval, Chebyshev);
    DoSome = (Go, Stop);
    LETTERS = string[200];

  var
    DNpts, GNpts, Inum, N, Ctype, Sub: integer;
    A, B, C, D, E2, L, Rnum, Xmax, Xmin, Ymax, Ymin: real;
    X, Y, X1, Y1: VECTOR;
    Xg, Yg: RVECTOR;
    ANS: LETTER;
    Stat, State: Status;
    Ytype: DATYPE;
    Xtype: ABTYPE;
    DoMo: DoSome;
    Mess: LETTERS;

  function F (X: real): real;
    var
      J, M: integer;
      XM: real;
  begin
    case Ctype of
      1: 
        F := A * X + B;
      2: 
        if X <> 0 then
          F := A / X + B
        else
          F := 1E10;
      3: 
        if X + C <> 0 then
          F := D / (X + C)
        else
          F := 1E10;
      4: 
        if A * X + B <> 0 then
          F := 1 / (A * X + B)
        else
          F := 1E10;
      5: 
        if A + B * X <> 0 then
          F := x / (A + B * X)
        else
          F := 1E10;
      6: 
        if X <> 0 then
          F := A * LN(ABS(X)) + B
        else
          F := 1E10;
      7: 
        F := C * EXP(A * X);
      8: 
        if X <> 0 then
          F := C * EXP(A * LN(ABS(X)))
        else
          F := 0;
      9: 
        if A * X + B <> 0 then
          F := 1 / SQR((A * X + B))
        else
          F := 1E10;
      10: 
        F := C * X * EXP(-D * X);
      11: 
        F := L / (1 + C * EXP(A * X));
      12: 
        begin
          F := C;
          M := ABS(TRUNC(A));
          XM := 1;
          for J := 1 to M do
            XM := XM * X;
          if A < 0 then
            if X <> 0 then
              XM := 1 / XM
            else
              XM := 1E10;
          if A <> 0 then
            F := C * XM;
        end;
    end;
  end;

  procedure REGRESSION (X, Y: VECTOR; N: integer; var A, B: real);
    var
      K: integer;
      Xmean, Ymean, SumX, SumXY: real;
  begin
    Xmean := 0;
    for K := 1 to N do
      Xmean := Xmean + X[K];
    Xmean := Xmean / N;
    Ymean := 0;
    for K := 1 to N do
      Ymean := Ymean + Y[K];
    Ymean := Ymean / N;
    SumX := 0;
    for K := 1 to N do
      SumX := SumX + (X[K] - Xmean) * (X[K] - Xmean);
    SumXY := 0;
    for K := 1 to N do
      SumXY := SumXY + (X[K] - Xmean) * (Y[K] - Ymean);
    A := SumXY / SumX;
    B := Ymean - A * Xmean
  end;

  procedure POWERFIT (X, Y: VECTOR; N: integer; var A, C: real);
    var
      J, K, M: integer;
      SumXX, SumXY, X1, X2, Ymean: real;
  begin
    M := ABS(TRUNC(A));
    if A = 0 then
      begin
        Ymean := 0;
        for K := 1 to N do
          Ymean := Ymean + Y[K];
        Ymean := Ymean / N;
        C := Ymean;
      end;
    if A < 0 then
      begin
        for K := 1 to N do
          begin
            if X[K] <> 0 then
              X[K] := 1 / X[K]
            else
              X[K] := 1E10;
          end
      end;
    SumXX := 0;
    SumXY := 0;
    for K := 1 to N do
      begin
        X1 := 1;
        for J := 1 to M do
          X1 := X1 * X[K];
        X2 := X1 * X1;
        SumXX := SumXX + X2;
        SumXY := SumXY + X1 * Y[K];
      end;
    if A <> 0 then
      C := SumXY / SumXX;
  end;

  procedure ChangeVariables (X1, Y1: VECTOR; var X, Y: VECTOR; N, Ctype: integer);
    var
      K: integer;
  begin
    case Ctype of
      1: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              Y[K] := Y1[K];
            end;
        end;
      2: 
        begin
          for K := 1 to N do
            begin
              if X1[K] <> 0 then
                X[K] := 1 / X1[K]
              else
                X[K] := 1E10;
              Y[K] := Y1[K];
            end;
        end;
      3: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K] * Y1[K];
              Y[K] := Y1[K];
            end;
        end;
      4: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              if Y1[K] <> 0 then
                Y[K] := 1 / Y1[K]
              else
                Y[K] := 1E10;
            end;
        end;
      5: 
        begin
          for K := 1 to N do
            begin
              if X1[K] <> 0 then
                X[K] := 1 / X1[K]
              else
                X[K] := 1E10;
              if Y1[K] <> 0 then
                Y[K] := 1 / Y1[K]
              else
                Y[K] := 1E10;
            end;
        end;
      6: 
        begin
          for K := 1 to N do
            begin
              if X1[K] <> 0 then
                X[K] := LN(ABS(X1[K]))
              else
                X[K] := 25;
              Y[K] := Y1[K];
            end;
        end;
      7: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              if Y1[K] <> 0 then
                Y[K] := LN(ABS(Y1[K]))
              else
                Y[K] := 25;
            end;
        end;
      8: 
        begin
          for K := 1 to N do
            begin
              if X1[K] <> 0 then
                X[K] := LN(ABS(X1[K]))
              else
                X[K] := 25;
              if Y1[K] <> 0 then
                Y[K] := LN(ABS(Y1[K]))
              else
                Y[K] := 25;
            end;
        end;
      9: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              if Y1[K] <> 0 then
                Y[K] := 1 / SQRT(ABS(Y1[K]))
              else
                Y[K] := 1E5;
            end;
        end;
      10: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              if X1[K] <> 0 then
                Y[K] := LN(ABS(Y1[K] / X1[K]))
              else
                Y[K] := 30;
            end;
        end;
      11: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              Y[K] := LN(ABS(L / Y1[K] - 1));
            end;
        end;
      12: 
        begin
          for K := 1 to N do
            begin
              X[K] := X1[K];
              Y[K] := Y1[K];
            end;
        end;
    end;
  end;

  procedure CONSTANTS (A, B: real; var C, D: real; Ctype: integer);
  begin
    case Ctype of
      1: 
        begin
        end;
      2: 
        begin
        end;
      3: 
        begin
          C := -1 / A;
          D := -B / A;
        end;
      4: 
        begin
        end;
      5: 
        begin
        end;
      6: 
        begin
        end;
      7: 
        begin
          C := EXP(B);
        end;
      8: 
        begin
          C := EXP(B);
        end;
      9: 
        begin
        end;
      10: 
        begin
          C := EXP(B);
          D := -A;
        end;
      11: 
        begin
          C := EXP(B);
        end;
    end;
  end;

  procedure ERROR (X, Y: VECTOR; A, B, C, D: real; var E2: real; var Ctype: integer);
    var
      K: integer;
      Err, Z: real;
  begin
    E2 := 0;
    for K := 1 to N do
      begin
        Z := F(X[K]);
        Err := Y[K] - Z;
        E2 := E2 + Err * Err;
      end;
    E2 := SQRT(E2 / N);
  end;

  procedure GETPOINTS (var X, Y, X1, Y1: VECTOR; var Xmin, Xmax: real; var N: integer; Stat: STATUS);
    type
      STATUS = (Bad, Enter, Done);
      LETTER = string[1];
    var
      Count, I, J, K, Kbad: integer;
      T, Valu: real;
      Resp: LETTER;
      Cond: STATUS;
  begin
    CLRSCR;
    Kbad := -1;
    Stat := Working;
    if Stat = More then
      begin
        for I := 1 to 6 do
          WRITELN;
        WRITE('Do you  want  to enter  new data points ?  <Y/N>  ');
        Resp := 'N';
        READLN(Resp);
        if (Resp = 'Y') or (Resp = 'y') then
          begin
            Stat := Working;
            CLRSCR;
          end;
      end;
    if (Stat = Working) then
      begin
        CLRSCR;
        Kbad := 0;
        for K := 1 to N do
          begin
            X[K] := 0;
            X1[K] := X[K];
            Y[K] := 0;
            Y1[K] := Y[K];
          end;
        CLRSCR;
        WRITELN;
        WRITELN('              Now enter the ', N : 2, ' points.');
        WRITELN;
        WRITELN('          You will have a chance to make changes at the end.');
        WRITELN;
        WRITELN;
        Xtype := Given;
        for K := 1 to N do
          begin
            if Xtype = Given then
              begin
                WRITELN;
                Mess := '         x';
                WRITE(Mess, K : 1, ' = ');
                READLN(X[K]);
              end;
            Ytype := DatPoints;
            if Ytype = DatPoints then
              begin
                if Xtype <> Given then
                  begin
                    WRITELN;
                    WRITELN('         x  =', X[K]);
                    WRITE('          ', K : 0);
                  end;
                WRITELN;
                Mess := '         y';
                WRITE(Mess, K : 1, ' = ');
                READLN(Y[K]);
                WRITELN;
              end
            else
              begin
            {Y[K]:=F(X[K]); Provision for function values.}
              end;
            WRITELN;
          end;
      end;
    Xmin := X[1];
    Ymin := Y[1];
    for K := 1 to N do
      begin
        if (Xmin > X[K]) then
          Xmin := X[K];
        if (Ymin > Y[K]) then
          Ymin := Y[K];
      end;
    Cond := Enter;
    while (Cond = Enter) or (Cond = Bad) do
      begin
        CLRSCR;
        if (Xmin <= 0) or (Ymin <= 0) then
          begin
            WRITELN('          The values LN(X[K]) and LN(Y[K]) are used in some computations.');
            WRITELN('     A program error might result when trying to fit some of the curves!');
          end;
        if (Cond = Bad) then
          WRITELN('     The abscissas are NOT distinct.   You MUST change one of them.');
        WRITELN('      k               x                     y');
        WRITELN('                       k                     k');
        WRITELN('----------------------------------------------------------------');
        for K := 1 to N do
          WRITELN('     ', K : 2, '       ', X[K] : 15 : 7, '       ', Y[K] : 15 : 7);
        WRITELN;
        if (Cond <> Bad) then
          begin
            WRITELN;
            if N > 15 then
              begin
                WRITELN;
              end;
            WRITE('     Are the points o.k. ?  <Y/N>  ');
            Resp := 'Y';
            READLN(Resp);
          end;
        if (Resp = 'N') or (Resp = 'n') or (Cond = Bad) then
          begin
            if N > 14 then
              WRITELN;
            WRITELN;
            WRITELN;
            case N of
              2: 
                WRITELN('     To change a point select  k = 1,2');
              3: 
                WRITELN('     To change a point select  k = 1,2,3');
              else
                WRITELN('     To change a point select  k = 1,2,...,', N : 2);
            end;
            Mess := '                       ENTER   k = ';
            K := Kbad;
            WRITE(Mess);
            READLN(K);
            if (1 <= K) and (K <= N) then
              begin
                WRITELN;
                if K < 10 then
                  begin
                    WRITELN('     Coordinates of the  current point  (x ,y )  are:');
                    WRITELN('                                          ', K : 1, '  ', k : 1);
                    WRITELN('     Old   x  =', X[K] : 15 : 7, '      Old   y  =', Y[K] : 15 : 7);
                    WRITELN('            ', K : 1, '                              ', K : 1);
                  end
                else
                  begin
                    WRITELN('     Coordinates of the current point  (x  ,y  )  are:');
                    WRITELN('                                         ', K : 2, '  ', k : 2);
                    WRITELN('     Old   x  =', X[K] : 15 : 7, '      Old   y  =', Y[K] : 15 : 7);
                    WRITELN('            ', K : 2, '                             ', K : 2);
                  end;
                Mess := '     NEW   x';
                WRITE(Mess, K : 1, ' = ');
                READLN(X[K]);
                Mess := '     NEW   y';
                WRITE(Mess, K : 1, ' = ');
                READLN(Y[K]);
              end;
          end
        else
          Cond := Done;
        if (Cond = Bad) then
          Cond := Enter;
        for J := 1 to N - 1 do
          begin
            for K := J + 1 to N do
              if X[J] > X[K] then
                begin
                  T := X[J];
                  X[J] := X[K];
                  X[K] := T;
                  T := Y[J];
                  Y[J] := Y[K];
                  Y[K] := T;
                end;
          end;
        Count := 0;
        for J := 2 to N do
          if (X[1] = X[J]) then
            Count := Count + 1;
        if Count = N - 1 then
          begin
            Kbad := N;
            Cond := Bad;
          end;
        Xmax := X[1];
        Xmin := X[1];
        Ymax := Y[1];
        Ymin := Y[1];
        for K := 1 to N do
          begin
            X1[K] := X[K];
            Y1[K] := Y[K];
            if (Xmax < X[K]) then
              Xmax := X[K];
            if (Xmin > X[K]) then
              Xmin := X[K];
            if (Ymax < Y[K]) then
              Ymax := Y[K];
            if (Ymin > Y[K]) then
              Ymin := Y[K];
          end;
      end;
  end;

  procedure INPUTS (var X, Y, X1, Y1: VECTOR; var Xmin, Xmax: real; var N: integer);
  begin
    CLRSCR;
    WRITELN('                              NONLINEAR CURVE FITTING');
    WRITELN;
    WRITELN;
    WRITELN('    The method of "data linearization" is used to fit one of the curves:');
    WRITELN;
    WRITELN;
    WRITELN('    y = A x + B         y = A/x + B          y = D/(x + C)      y = 1/(A x + B) ');
    WRITELN;
    WRITELN('    y = x/(A + B x)     y = A Ln(x) + B      y = C Exp(A x)     y = C x^A');
    WRITELN;
    WRITELN('    y = (A x + B)^-2    y = C x Exp(-D x)');
    WRITELN;
    WRITELN('    y = L/(1 + C Exp(A x))  where L is given.');
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('    The curve will be "fit close" to the  N  data points:');
    WRITELN;
    WRITELN;
    WRITELN('    (x ,y ), (x ,y ),..., (x ,y ).');
    WRITELN('      1  1     2  2         N  N  ');
    WRITELN;
    WRITELN;
    Mess := '    ENTER the number of points N = ';
    N := 2;
    WRITE(Mess);
    READLN(N);
    if N < 2 then
      N := 2;
    if N > 100 then
      N := 100;
    GETPOINTS(X, Y, X1, Y1, Xmin, Xmax, N, Stat);
  end;

  procedure RESULTS (X, Y: VECTOR; A, B, C, D, E2: real; Ctype: integer);
    var
      K: integer;
      Err, Z: real;
  begin
    CLRSCR;
    WRITELN;
    case Ctype of
      1: 
        begin
          WRITELN('  f(x) = A x  +  B');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      2: 
        begin
          WRITELN('  f(x) = A/x  +  B');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      3: 
        begin
          WRITELN('  f(x) = D/( x + C )');
          WRITELN;
          WRITELN('    D  = ', D : 15 : 7, '             C  = ', C : 15 : 7);
        end;
      4: 
        begin
          WRITELN('  f(x) = 1/( A x + B )');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      5: 
        begin
          WRITELN('  f(x) = x/( A + B x )');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      6: 
        begin
          WRITELN('  f(x) = A Ln(x)  +  B');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      7: 
        begin
          WRITELN('  f(x) = C Exp(A x)');
          WRITELN;
          WRITELN('    C  = ', C : 15 : 7, '             A  = ', A : 15 : 7);
        end;
      8: 
        begin
          WRITELN('  f(x) = C x^A');
          WRITELN;
          WRITELN('    C  = ', C : 15 : 7, '             A  = ', A : 15 : 7);
        end;
      9: 
        begin
          WRITELN('  f(x) = ( A x + B )^-2');
          WRITELN;
          WRITELN('    A  = ', A : 15 : 7, '             B  = ', B : 15 : 7);
        end;
      10: 
        begin
          WRITELN('  f(x) = C x EXP(-D x)');
          WRITELN;
          WRITELN('    C  = ', C : 15 : 7, '             D  = ', D : 15 : 7);
        end;
      11: 
        begin
          WRITELN('  f(x) = L/( 1 + C EXP(A x) )');
          WRITELN;
          WRITELN('    L  = ', L : 15 : 7);
          WRITELN;
          WRITELN('    C  = ', C : 15 : 7, '             A  = ', A : 15 : 7);
        end;
      12: 
        begin
          WRITELN('  f(x) = C x^A');
          WRITELN;
          WRITELN('    C  = ', C : 15 : 7, '             A  = ', A : 15 : 7);
        end;
    end;
    WRITELN;
    WRITELN('    k       x             y             F(x )         Error');
    WRITELN('             k             k               k');
    WRITELN('  -------------------------------------------------------------');
    for K := 1 to N do
      begin
        Z := F(X[K]);
        Err := Y[K] - Z;
        WRITELN(K : 5, X[K] : 14 : 7, Y[K] : 14 : 7, Z : 14 : 7, Err : 14 : 7);
      end;
    WRITELN;
    WRITELN('The R. M. S. error is  E  = ', E2 : 15 : 7);
    WRITE('                        2');
  end;

  procedure CURVETYPE (var Ctype: integer; var A: real);
    var
      Choice: integer;
      Resp: real;
  begin
    CLRSCR;
    WRITELN('Curves which can be fit to your data.');
    WRITELN;
    WRITELN('       <1>    y = A x + B');
    WRITELN;
    WRITELN('       <2>    y = A/x + B');
    WRITELN;
    WRITELN('       <3>    y = D/(x + C)');
    WRITELN;
    WRITELN('       <4>    y = 1/(A x + B)');
    WRITELN;
    WRITELN('       <5>    y = x/(A + B x)');
    WRITELN;
    WRITELN('       <6>    y = A Ln(x) + B');
    WRITELN;
    WRITELN('       <7>    y = C Exp(A x)');
    WRITELN;
    WRITELN('       <8>    y = C x^A');
    WRITELN;
    WRITELN('       <9>    y = (A x + B)^-2');
    WRITELN;
    WRITELN('      <10>    y = C x EXP(-D x)');
    WRITELN;
    WRITELN('      <11>    y = L/(1 + C EXP(A x))');
    WRITELN;
    Mess := '        Select a curve type.  <1 - 11 >  ';
    Ctype := 1;
    WRITE(Mess);
    READLN(Ctype);
    if (Ctype < 1) or (11 < Ctype) then
      Ctype := 1;
    if Ctype = 8 then
      begin
        CLRSCR;
        WRITELN;
        WRITELN('         You chose the curve  Y  =  C x^A ');
        WRITELN;
        WRITELN('         Now chose an options for the exponent A.');
        WRITELN;
        WRITELN('     <1> The computer will find  A.');
        WRITELN;
        WRITELN('     <2> The exponent A is a known and is an integer.');
        WRITELN;
        WRITELN('     <3> The exponent A is a known and is a real number.');
        Mess := '         Select <1 - 3>  ';
        Choice := 1;
        WRITE(Mess);
        READLN(Choice);
        if (Choice < 1) or (3 < Choice) then
          Choice := 1;
        if (Choice = 2) then
          begin
            Mess := '         Enter the exponent A = ';
            A := 1;
            WRITE(Mess);
            READLN(A);
            A := TRUNC(A);
            Ctype := 12;
          end;
        if (Choice = 3) then
          begin
            WRITELN;
            Mess := '         Enter the exponent A = ';
            A := 1;
            WRITE(Mess);
            READLN(A);
          end;
      end;
    if Ctype = 11 then
      begin
        CLRSCR;
        WRITELN;
        WRITELN('     You chose the curve  y  =  L/(1 + C EXP(A x))');
        WRITELN;
        WRITELN('     The limiting  value  L  =   lim   y(x)  must be given.');
        WRITELN('                                x ->oo ');
        WRITELN;
        Mess := '     ENTER  the  value    L = ';
        L := 1;
        WRITE(Mess);
        READLN(L);
        if (L <= Ymax) then
          begin
            L := 1.00001 * ABS(Ymax);
            WRITELN;
            WRITELN;
            WRITELN('     Sorry, L must be larger than  ', Ymax);
            WRITELN;
            WRITELN('     Therefore, I have chosen  L = ', L);
            WRITELN;
            WRITE('     Press the <ENTER> key.  ');
            READLN(ANS);
          end;
      end;
  end;

begin                                            {Begin Main Program}
  DoMo := Go;
  while DoMo = Go do
    begin
      INPUTS(X, Y, X1, Y1, Xmin, Xmax, N);
      Stat := Working;
      while Stat = Working do
        begin
          CURVETYPE(Ctype, A);
          ChangeVariables(X1, Y1, X, Y, N, Ctype);
          if Ctype < 12 then
            begin
              REGRESSION(X, Y, N, A, B);
              CONSTANTS(A, B, C, D, Ctype);
            end;
          if Ctype = 12 then
            POWERFIT(X, Y, N, A, C);
          ERROR(X1, Y1, A, B, C, D, E2, Ctype);
          RESULTS(X1, Y1, A, B, C, D, E2, Ctype);
          WRITELN;
          WRITELN;
          WRITE('Want to fit another curve with the data ?  <Y/N>  ');
          READLN(ANS);
          if (ANS <> 'Y') and (ANS <> 'y') then
            Stat := Done;
        end;
      WRITELN;
      WRITE('Want to run the program using  new data ?  <Y/N>  ');
      READLN(Ans);
      if (Ans <> 'Y') and (Ans <> 'y') then
        DoMo := Stop;
    end;
end.                                            {End of Main Program}

